function highlightSearch(search) {
        var exps = search.split(' ');

        // Regulärer Ausdruck für Zeichen das nicht zu einem Wort gehöhren
        // und daher eine Wortgrenze darstellen.
        // Aktuell sind hier neben Whitespaces (RegExp Zeichenklasse \s) die
        // folgenden Zeichen kodiert: ^!"§$%&/(){}[]=?*+'#<>|,.-;:_
        var wordsReg = new RegExp('[\\s\\'
                + '^\\!"§\\$%&\\/\\(\\)\\{\\}\\[\\]=?\\\\'
                + '\\*\\+\'#<>\\|,\\.\\-;:_]+', '');

        // Suchwörter markieren
        for (var idx = 0; idx < exps.length; ++idx) {
            var searchReg = new RegExp('^' + unescape(exps[idx]) + '$', 'i');
            _doHighlightSearch(
                    document.getElementById('content'),
                    wordsReg, searchReg);
        }
   
}

/**
 * Traversiert den DOM Baum mit dem gegebenen Wurzelknoten rekursiv und
 * führt für jeden Textknoten die Worthervorhebung aus.
 *
 * @param node der DOM Knoten
 * @param wordsReg der reguläre Ausdruck für Wortgrenzen (RegExp)
 * @param searchReg der reguläre Ausdruck für das Suchwort (RegExp)
 */
function _doHighlightSearch(node, wordsReg, searchReg) {
    for (var idx = 0; idx < node.childNodes.length; ++idx) {
        var child = node.childNodes[idx];
        if (child.nodeType == 3) { // TEXT_NODE
            // Suchwörter hervorheben
            // dabei wird node.childNodes verändert
            idx += _doHighlightWords(node, child, wordsReg, searchReg);
        } else if ((child.nodeType == 1) // ELEMENT_NODE
                && (child.tagName == 'span')
                && (child.className == 'highlight')) {
            // der Knoten ist bereits eine Hervorhebung
            // noop
        } else {
            // rekursiv abarbeiten
            _doHighlightSearch(child, wordsReg, searchReg);
        }
        
    }
}

/**
 * Führt die Markierung im Text des gegebenen DOM Textknotens mit dem
 * gegebenen reguläre Ausdruck aus.
 *
 * @param parent der übergeordnete DOM Knoten
 * @param node der DOM Textknoten (nodeType == 3)
 * @param wordsReg der reguläre Ausdruck für Wortgrenzen (RegExp)
 * @param searchReg der reguläre Ausdruck für das Suchwort (RegExp)
 * @return die Anzahl zusätzlich erzeugter Kinder im übergeordneten DOM Knoten
 */
function _doHighlightWords(parent, node, wordsReg, searchReg) {
    var res = 0;

    // nach Wortgrenzen suchen
    var text = node.nodeValue;
    //alert('Knoten: _' + text + '_');
    var textBefore = '';
    var wordsMatch = wordsReg.exec(text);
    while (wordsMatch != null) {
        var idx = wordsMatch.index;
        var len = wordsMatch.toString().length;
        
        // Text vor der Wortgrenze auswerten
        var txt = text.substring(0, idx);
        if (searchReg.test(txt)) {
            // Text vor dem Treffer ausgeben
            if (textBefore.length > 0) {
                //alert('Txt: _' + textBefore + '_');
                parent.insertBefore(
                        document.createTextNode(textBefore), node);
                ++res;
                textBefore = '';
            }
            // Treffer mit Hervorhebung ausgeben
            //alert('Hit: _' + txt + '_');
            var eHighlight = document.createElement('span');
            eHighlight.className = 'highlight';
            eHighlight.appendChild(document.createTextNode(txt));
            parent.insertBefore(eHighlight, node);
            ++res;
        } else {
            // sonstigen Text sammeln
            textBefore += txt;
        }

        // Wortgrenze als sonstigen Text sammeln
        textBefore += wordsMatch.toString();
    
        // weiter suchen
        text = text.substring(idx + len);
        wordsMatch = wordsReg.exec(text);
    }
    
    // restlichen Text auswerten
    if (text.length > 0) {
        if (searchReg.test(text)) {
            // Text vor dem Treffer ausgeben
            if (textBefore.length > 0) {
                //alert('Txt: _' + textBefore + '_');
                parent.insertBefore(
                        document.createTextNode(textBefore), node);
                ++res;
                textBefore = '';
            }
            // Treffer mit Hervorhebung ausgeben
            //alert('Hit: _' + text + '_');
            var eHighlight = document.createElement('span');
            eHighlight.className = 'highlight';
            eHighlight.appendChild(document.createTextNode(text));
            parent.insertBefore(eHighlight, node);
            ++res;
        } else {
            // sonstigen Text sammeln
            textBefore += text;
        }
    }

    // Text nach dem letzten Treffer in den alten Textknoten setzen
    if (textBefore.length > 0) {
        //alert('Txt: _' + textBefore + '_');
        node.nodeValue = textBefore;
        textBefore = '';
    } else {
        // alten Textknoten entfernen
        parent.removeChild(node);
    }
    
    return res;
}
